/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Handles;
using Borland.Eco.UmlRt;

namespace Borland.Eco.AutoContainers
{
	///<summary>
	///Default autocontainerdactory to handle lists
	///</summary>
	public class DefaultListContainerFactory: IAutoContainerFactory
	{
		// IAutoContainerFactory
		public IAutoContainer AutoContainer { get { return new DefaultAutoListForm(); } }
		// IAutoContainerFactory
		public bool Matches(IModelElement modelElement)
		{
			return (modelElement is ICollectionType);
		}
	}
	/// <summary>
	/// Summary description for WinForm1.
	/// </summary>
	internal class DefaultAutoListForm: System.Windows.Forms.Form, IAutoContainer
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.DataGrid grid;
		private System.Windows.Forms.Button cmdClose;
		private Borland.Eco.Handles.ReferenceHandle rh;

		public DefaultAutoListForm()
		{
			InitializeComponent();
		}
		public EcoSpace EcoSpace
		{
			set { rh.EcoSpace = value; }
		}
		private AutoContainerArgs m_autoContainerArgs;
		///<exception cref="ArgumentNullException">Thrown if <paramref name="element"/> is null.</exception>
		public void BuildControls(IElement element, AutoContainerArgs autoContainerArgs)
		{
			if (element == null) throw new ArgumentNullException("element"); // Do not localize
			this.m_autoContainerArgs = autoContainerArgs;
			IModelElement modelElement = element.UmlType;
			IClassifier classifier = modelElement as IClassifier;
			rh.StaticValueTypeName = classifier.Name;
			grid.CaptionText = classifier.Name;
			if (autoContainerArgs == null)
				grid.DoubleClick -= new System.EventHandler(this.grid_DoubleClick);
			else
				grid.ReadOnly = m_autoContainerArgs.ForceReadOnly;
		}
		// IAutoContainer
		///<exception cref="ArgumentNullException">Thrown if <paramref name="ecoSpace"/> is null.</exception>
		public void HookUpGUI(EcoSpace ecoSpace, IElement element)
		{
			if (ecoSpace == null) throw new ArgumentNullException("ecoSpace"); // Do not localize
			rh.EcoSpaceType = ecoSpace.GetType();
			rh.SetElement(element);
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="autoContainerArgs"/> is null.</exception>
		public void Show(AutoContainerArgs autoContainerArgs)
		{
			if (autoContainerArgs == null)
				throw new ArgumentNullException("autoContainerArgs");
			if (autoContainerArgs.ShowModal)
				this.ShowDialog();
			else
				this.Show();
			this.BringToFront();
		}
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DefaultAutoListForm));
			this.grid = new System.Windows.Forms.DataGrid();
			this.rh = new Borland.Eco.Handles.ReferenceHandle();
			this.cmdClose = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.grid)).BeginInit();
			this.SuspendLayout();
			//
			// grid
			//
			this.grid.AccessibleDescription = resources.GetString("grid.AccessibleDescription");
			this.grid.AccessibleName = resources.GetString("grid.AccessibleName");
			this.grid.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("grid.Anchor")));
			this.grid.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("grid.BackgroundImage")));
			this.grid.CaptionFont = ((System.Drawing.Font)(resources.GetObject("grid.CaptionFont")));
			this.grid.CaptionText = resources.GetString("grid.CaptionText");
			this.grid.DataMember = "";
			this.grid.DataSource = this.rh;
			this.grid.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("grid.Dock")));
			this.grid.Enabled = ((bool)(resources.GetObject("grid.Enabled")));
			this.grid.Font = ((System.Drawing.Font)(resources.GetObject("grid.Font")));
			this.grid.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.grid.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("grid.ImeMode")));
			this.grid.Location = ((System.Drawing.Point)(resources.GetObject("grid.Location")));
			this.grid.Name = "grid";
			this.grid.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("grid.RightToLeft")));
			this.grid.Size = ((System.Drawing.Size)(resources.GetObject("grid.Size")));
			this.grid.TabIndex = ((int)(resources.GetObject("grid.TabIndex")));
			this.grid.Visible = ((bool)(resources.GetObject("grid.Visible")));
			this.grid.DoubleClick += new System.EventHandler(this.grid_DoubleClick);
			//
			// cmdClose
			//
			this.cmdClose.AccessibleDescription = resources.GetString("cmdClose.AccessibleDescription");
			this.cmdClose.AccessibleName = resources.GetString("cmdClose.AccessibleName");
			this.cmdClose.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("cmdClose.Anchor")));
			this.cmdClose.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("cmdClose.BackgroundImage")));
			this.cmdClose.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("cmdClose.Dock")));
			this.cmdClose.Enabled = ((bool)(resources.GetObject("cmdClose.Enabled")));
			this.cmdClose.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("cmdClose.FlatStyle")));
			this.cmdClose.Font = ((System.Drawing.Font)(resources.GetObject("cmdClose.Font")));
			this.cmdClose.Image = ((System.Drawing.Image)(resources.GetObject("cmdClose.Image")));
			this.cmdClose.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("cmdClose.ImageAlign")));
			this.cmdClose.ImageIndex = ((int)(resources.GetObject("cmdClose.ImageIndex")));
			this.cmdClose.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("cmdClose.ImeMode")));
			this.cmdClose.Location = ((System.Drawing.Point)(resources.GetObject("cmdClose.Location")));
			this.cmdClose.Name = "cmdClose";
			this.cmdClose.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cmdClose.RightToLeft")));
			this.cmdClose.Size = ((System.Drawing.Size)(resources.GetObject("cmdClose.Size")));
			this.cmdClose.TabIndex = ((int)(resources.GetObject("cmdClose.TabIndex")));
			this.cmdClose.Text = resources.GetString("cmdClose.Text");
			this.cmdClose.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("cmdClose.TextAlign")));
			this.cmdClose.Visible = ((bool)(resources.GetObject("cmdClose.Visible")));
			this.cmdClose.Click += new System.EventHandler(this.cmdClose_Click);
			//
			// DefaultAutoListForm
			//
			this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
			this.AccessibleName = resources.GetString("$this.AccessibleName");
			this.AutoScaleBaseSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScaleBaseSize")));
			this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
			this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
			this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
			this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
			this.ClientSize = ((System.Drawing.Size)(resources.GetObject("$this.ClientSize")));
			this.Controls.Add(this.cmdClose);
			this.Controls.Add(this.grid);
			this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
			this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
			this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
			this.MaximumSize = ((System.Drawing.Size)(resources.GetObject("$this.MaximumSize")));
			this.MinimumSize = ((System.Drawing.Size)(resources.GetObject("$this.MinimumSize")));
			this.Name = "DefaultAutoListForm";
			this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
			this.ShowInTaskbar = false;
			this.StartPosition = ((System.Windows.Forms.FormStartPosition)(resources.GetObject("$this.StartPosition")));
			this.Text = resources.GetString("$this.Text");
			((System.ComponentModel.ISupportInitialize)(this.grid)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion

		private void cmdClose_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void grid_DoubleClick(object sender, System.EventArgs e)
		{
			DataGrid grid = sender as DataGrid;
			int curIndex = grid.CurrentRowIndex;
			if ( curIndex < 0)
				return;

			IObjectList objectList = ((ReferenceHandle)(grid.DataSource)).Element as IObjectList;
			IAutoContainer a = AutoContainerService.Instance.CreateContainer(objectList[curIndex], m_autoContainerArgs);
			a.Show(m_autoContainerArgs);
		}
	}
}
